module("luci.controller.moreconn", package.seeall)

function index()
    entry({"admin", "oplus"}, firstchild(), "OP+", 60).dependent=true
	entry({"admin", "oplus", "moreconn"}, template("moreconn"), _("MoreConn"), 25)

    entry({"admin", "oplus", "moreconn_set"}, call("moreconn_set"), nil, nil)
    entry({"admin", "oplus", "moreconn_get"}, call("moreconn_get"), nil, nil)

    entry({"admin", "oplus", "connlimit_get"}, call("connlimit_get"), nil, nil)   
    entry({"admin", "oplus", "connlimit_set"}, call("connlimit_set"), nil, nil)
end

function connlimit_get()
    local interfaces = luci.util.exec("uci get moreconn.setting.interfaces 2>/dev/null")
    interfaces = string.gsub(interfaces, "\n", "")

    local connlimit = luci.util.exec("uci get moreconn.setting.connlimit 2>/dev/null")
    connlimit = string.gsub(connlimit, "\n", "")

    luci.http.prepare_content("application/javascript")
	luci.http.write("on_connlimit_get('".. interfaces .."', '".. connlimit .."');")
end

function connlimit_set() 
    local interfaces = luci.http.formvalue("interfaces")
    local connlimit = luci.http.formvalue("connlimit")

    if not connlimit:match("^%d+$") or tonumber(connlimit) < 0 then
        luci.http.prepare_content("application/javascript")
        luci.http.write("on_connlimit_set(1);")
        return
    end

    luci.util.exec("uci set moreconn.setting.interfaces='".. interfaces .."'; uci set moreconn.setting.connlimit='".. connlimit .."'; uci commit moreconn; /etc/init.d/moreconn restart")
    luci.http.prepare_content("application/javascript")
	luci.http.write("on_connlimit_set(0);")
end

function moreconn_get()
	local max = luci.util.exec("sysctl -n net.netfilter.nf_conntrack_max 2>/dev/null")
    max = string.gsub(max, "\n", "")

    local cur = luci.util.exec("wc -l /proc/net/nf_conntrack 2>/dev/null | awk '{print $1}'")
    cur = string.gsub(cur, "\n", "")

	luci.http.prepare_content("application/javascript")
	luci.http.write("onGet('".. cur .."', '".. max .."');")
end

function moreconn_set()
    local result = luci.util.exec("oplus-util verify 2>/dev/null");
    result = string.gsub(result, "\n", "")
    if result ~= "license_ok" then
        luci.http.prepare_content("application/javascript")
        luci.http.write("onSet(9);")
        return
    end

	local myMax = luci.http.formvalue("myMax")

    if not myMax:match("^%d+$") or tonumber(myMax) <= 0 then
        luci.http.prepare_content("application/javascript")
        luci.http.write("onSet(1);")
        return
    end

    myMax = string.gsub(myMax, "\n", "")

    local result = luci.util.exec("set_conntrack_max.sh ".. myMax .." 2>/dev/null")
    result = string.gsub(result, "\n", "")
    
	luci.http.prepare_content("application/javascript")
	luci.http.write("onSet(0);")
end