#!/bin/sh
# ShareBlock
# A part of Oplus.
# Copyright(c) 2025 wiwiz.com. All rights reserved.

LOGFILE=/tmp/wiwiz_shareblock.log

sleep 2

if [ "$1" == "start" ]; then
    echo "$(date) START" >>$LOGFILE
    uci show shareblock >>$LOGFILE
    ENABLED=$(uci get shareblock.setting.enabled 2>/dev/null)
    if [ "$ENABLED" != "1" ]; then
        echo "$(date) DISABLED" >>$LOGFILE
        exit 1
    fi

    COUNT=$(uci show shareblock | grep '=shareblock' 2>/dev/null | wc -l)
    for i in $(seq 0 $(expr $COUNT - 1)); do
        interface=$(uci get shareblock.@shareblock[$i].interface 2>/dev/null)
        ttl=$(uci get shareblock.@shareblock[$i].ttl 2>/dev/null)
        ipaddr=$(uci get network.$interface.ipaddr 2>/dev/null)
        mask=$(uci get network.$interface.netmask 2>/dev/null)

        ipaddr1=$(echo "$ipaddr" | cut -d '.' -f 1)
        ipaddr2=$(echo "$ipaddr" | cut -d '.' -f 2)
        ipaddr3=$(echo "$ipaddr" | cut -d '.' -f 3)
        netip="$ipaddr1.$ipaddr2.$ipaddr3.0"

        echo "interface = $interface, ttl = $ttl, ipaddr = $ipaddr, netip = $netip, mask = $mask" >>$LOGFILE

        for T in $ttl; do
            oplus-util fa "$netip"/"$mask" "$T"
        done
    done
elif [ "$1" == "stop" ]; then
    echo "$(date) STOP" >>$LOGFILE
    COUNT=$(oplus-util fc 2>/dev/null | wc -l )
    for i in $(seq 0 $(expr $COUNT - 1)); do
        INDEX=$(oplus-util fc | awk '{print $1}' | head -n 1 2>/dev/null)
        if [ "$INDEX" != "" ]; then
            oplus-util fd "$INDEX"
        fi
    done
else
    echo 'Usage: shareblock.sh start/stop'
fi