#!/bin/sh
# ResetLock
# A part of Oplus.
# Copyright(c) 2025 wiwiz.com. All rights reserved.

ENABLED=$(uci get resetlock.setting.enabled 2>/dev/null)
DEVCODE=$(oplus-util devcode 2>/dev/null)
SRVURL=$(uci get oplus.setting.srvurl 2>/dev/null)
MAC=$(ifconfig br-lan | grep HWaddr | awk '{print $5}' 2>/dev/null)

if [ "$ENABLED" == "1" ]; then
    mv /etc/rc.button/reset /etc/rc.button/oplus-reset.lock
    curl -m 30 -X POST --data-urlencode "MAC=$MAC" "$SRVURL/cgi/oplusevent/?event=resetLock&devcode=$DEVCODE" 2>/dev/null
fi

if [ "$ENABLED" == "0" ]; then
    mv /etc/rc.button/oplus-reset.lock /etc/rc.button/reset
fi