module("luci.controller.ontime", package.seeall)

local n = require"luci.sys.zoneinfo"

function index()
    entry({"admin", "oplus"}, firstchild(), "OP+", 60).dependent=true
    -- entry({"admin", "oplus", "ontime"}, firstchild(), _("OnTime"), 60).dependent=true
	entry({"admin", "oplus", "ontime"}, template("ontime"), _("OnTime"), 20)

	entry({"admin", "oplus", "ontime_set_time"}, call("ontime_set_time"), nil, nil)
    entry({"admin", "oplus", "ontime_load_sys_time"}, call("ontime_load_sys_time"), nil, nil)
end

function find_timezone(tz_name)
    for _, tz in ipairs(n.TZ) do
        if tz[1] == tz_name then
            return tz[2]  -- 返回对应的时区信息
        end
    end
    return nil  -- 如果未找到，返回 nil
end

function ontime_load_sys_time()
	local t = luci.sys.exec("date \"+%Y-%m-%d %H:%M:%S\"")
    t = string.gsub(t, "\n", "")
    local zonename = luci.sys.exec("uci get system.@system[0].zonename 2>/dev/null")
    zonename = string.gsub(zonename, "\n", "")

	luci.http.prepare_content("application/javascript")
	luci.http.write("onLoadSysTime('".. t .."','".. zonename .."');")
end

function ontime_set_time()
	local time = luci.http.formvalue("time")
    local zonename = luci.http.formvalue("zonename")
    local timezone = find_timezone(zonename);
    if(timezone == nil) then
        timezone = "UTC"
    end

    if(timezone ~= "") then
        luci.util.exec("uci set system.@system[0].zonename='" .. zonename .. "'; uci set system.@system[0].timezone='".. timezone .."' ; uci commit system; /etc/init.d/system restart")
    end

    luci.util.exec("date -s ".. time)

	luci.http.prepare_content("application/javascript")
	luci.http.write("onSetTime('0');")
end