local ut = require "luci.util"

local m, s

m = Map("rebootplan", translate("RebootPlan"), 
    "<b>".. translate("This tool is used for scheduled reboots") .."</b><br /><br />"..
    translate("Planned reboots can bring significant benefits to maintaining network stability") .."<br /><br />"
)

g = m:section(TypedSection, "global", translate("Global Settings"), "")
enabled = g:option(Flag, "enabled", translate("Enable scheduled reboot"));
enabled.optional = false 
enabled.rmempty = false
enabled.default = '0'

function enabled.validate(self, value, section)
    local result = ut.exec("oplus-util verify 2>/dev/null");
    result = string.gsub(result, "\n", "")
    if result ~= "license_ok" then
        return nil, translate("No valid license. Please activate your license first.")
    else
        return value
    end
end

s = m:section(TypedSection, "rebootplan", translate("Choose the time to reboot"))
--s.template = "cbi/tblsection"
s.anonymous = true
s.addremove = true

week_day = s:option(MultiValue, "week_day", translate("Day of week"), "")
week_day:value("1", translate("Mon"))
week_day:value("2", translate("Tue"))
week_day:value("3", translate("Wed"))
week_day:value("4", translate("Thu"))
week_day:value("5", translate("Fri"))
week_day:value("6", translate("Sat"))
week_day:value("7", translate("Sun"))
week_day.optional = false
week_day.rmempty = false
week_day.widget = "checkbox"
week_day.delimiter = " "

month_day = s:option(MultiValue, "month_day", translate("Day of month"), "")
for i = 1, 31 do
    month_day:value(i, i)
end
month_day.optional = false
month_day.rmempty = false
month_day.widget = "checkbox"
month_day.delimiter = " "

hr = s:option(ListValue, "hr", translate("Hour"), "")
for i = 0, 23 do
    hr:value(i, i)
end
hr.optional = false
hr.rmempty = false
hr.widget = "select"

min = s:option(ListValue, "min", translate("Minute"), "") 
for i = 0, 59 do
    min:value(i, i)
end
min.optional = false
min.rmempty = false
min.widget = "select"

m.on_after_commit = function(self)
    ut.exec("oplus-util rebootplan &")
end

-- m.on_before_save = function(self)
--     local result = ut.exec("oplus-util verify 2>/dev/null");
--     result = string.gsub(result, "\n", "")
--     if result ~= "license_ok" then
--         luci.http.redirect(luci.dispatcher.build_url("admin", "oplus", "oplus") .. "?error=" .. result)
--         return false
--     end
-- end

return m
