#!/bin/sh
# A part of Oplus.
# Copyright(c) 2025 wiwiz.com. All rights reserved.

SRVURL=$(uci get oplus.setting.srvurl 2>/dev/null)
DEVCODE=$(oplus-util devcode 2>/dev/null)
NOW=$(date +%s)
VER=$(uci get oplus.setting.ver 2>/dev/null)

MODEL=$(getmodel.sh 2>/dev/null)

get_value() {
    local key=$1
    grep -E "^$key=" /etc/openwrt_release | cut -d'=' -f2 | sed "s/'//g"
}

DISTRIB_DESCRIPTION=$(get_value DISTRIB_DESCRIPTION)
DISTRIB_TARGET=$(get_value DISTRIB_TARGET)
DISTRIB_ARCH=$(get_value DISTRIB_ARCH)

RESP=$(curl -m 30 -X POST \
    --data-urlencode "MODEL=$MODEL" --data-urlencode "DISTRIB_DESCRIPTION=$DISTRIB_DESCRIPTION" \
    --data-urlencode "DISTRIB_TARGET=$DISTRIB_TARGET" --data-urlencode "DISTRIB_ARCH=$DISTRIB_ARCH" \
    --data-urlencode "ver=$VER" \
    "$SRVURL/cgi/oplusactivate/?devcode=$DEVCODE&ts=$NOW" 2>/dev/null)
if [ "$RESP" == "" ]; then
        echo "error"
        exit 1
fi

RESP1=$(echo "$RESP" | awk '{print $1}')
if [ "$RESP1" == "OPLUS_LICENSE" ]; then
    echo "$RESP">/etc/oplus-license
    echo 'ok'
    exit 0
elif [ "$RESP1" == "NO_LICENSE" ]; then
    echo 'no_license'
    exit 2
else
    echo 'error'
    exit 9
fi
