local ut = require "luci.util"

local m, s

m = Map("resetlock", translate("ResetLock"), 
    "<b>".. translate("This tool is used for locking and unlocking hard factory reset (the physical reset button, if available).") .."</b><br /><br />"..
    translate("Only the function of hard factory reset is affected. Soft factory reset, failsafe mode or recovery mode is not affected if available.") .."<br /><br />" ..
    "<font color=\"red\"><b>" ..
    translate("[CAUTION] Once the reset button is locked, forgetting password, wrong settings, or encountering malfunctions will result in the device being unusable. Thus, the manufacturer or seller of the equipment may refuse to provide after-sales service So use it VERY CAREFULLY and only when necessary !") ..
    "</font></b>"
)

g = m:section(TypedSection, "global", translate("Global Settings"), "")
enabled = g:option(Flag, "enabled", translate("Lock Reset Button"));
enabled.optional = false 
enabled.rmempty = false
enabled.default = '0'

function enabled.validate(self, value, section)
    local result = ut.exec("oplus-util verify 2>/dev/null");
    result = string.gsub(result, "\n", "")
    if result ~= "license_ok" then
        return nil, translate("No valid license. Please activate your license first.")
    else
        return value
    end
end

m.on_after_commit = function(self)
    ut.exec("(sleep 3; /usr/bin/resetlock.sh) &")
end

return m
