local ut = require "luci.util"

local m, s

m = Map("shareblock", translate("ShareBlock"), 
    translate("This plugin can prevent PCs or smart phones in a sub LAN (e.g. a sub router or a mobile hotspot) from accessing the Internet<br />Note: There might be some problems on complicated networks or some special traffic. Do not use the plugin or change the Mask Values in this case.") .. "<br /><br />")

g = m:section(TypedSection, "global", translate("Global Settings"))
enabled = g:option(Flag, "enabled", translate("Enable"));
enabled.optional = false 
enabled.rmempty = false
enabled.default = '0'

function enabled.validate(self, value, section)
    local result = ut.exec("oplus-util verify 2>/dev/null");
    result = string.gsub(result, "\n", "")
    if result ~= "license_ok" then
        return nil, translate("No valid license. Please activate your license first.")
    else
        return value
    end
end

s = m:section(TypedSection, "shareblock", "")
s.template = "cbi/tblsection"
s.anonymous = true
s.addremove = true

interface = s:option(Value, "interface", translate("Network Interface"), translate("name of the network interface (not the device name), in lower case"))
interface.optional = false 
interface.rmempty = false
interface.default = "lan"

ttl = s:option(Value, "ttl", translate("Mask Values"), translate("Seperated by space. Recommended to use default value. Do not change it if you do not know what you are doing."))
ttl.optional = false 
ttl.rmempty = false
ttl.default = "62 63 126 127"

m.on_after_commit = function(self)
    ut.exec("/etc/init.d/shareblock restart &")
end

-- m.on_before_save = function(self)
--     local result = ut.exec("oplus-util verify 2>/dev/null");
--     result = string.gsub(result, "\n", "")
--     if result ~= "license_ok" then
--         luci.http.redirect(luci.dispatcher.build_url("admin", "oplus", "oplus") .. "?error=" .. result)
--         return false
--     end
-- end

return m
