module("luci.controller.oplus", package.seeall)

function index()
    entry({"admin", "oplus"}, firstchild(), "OP+", 60).dependent=true
	entry({"admin", "oplus", "oplus"}, template("oplus"), _("License and Activation"), 1)
    entry({"admin", "oplus", "oplus_loaddata"}, call("oplus_loaddata"), nil, nil)
	entry({"admin", "oplus", "oplus_activate"}, call("oplus_activate"), nil, nil)
    entry({"admin", "oplus", "oplus_activate_m"}, call("oplus_activate_m"), nil, nil)
end

function oplus_loaddata()
    local devcode = luci.util.exec("oplus-util devcode 2>/dev/null")
    devcode = string.gsub(devcode, "\n", "")
    local verify = luci.util.exec("oplus-util verify 2>/dev/null")  -- license_expired, license_ok, license_error
    verify = string.gsub(verify, "\n", "")
    local lic_date = luci.util.exec("oplus-util lic_date 2>/dev/null") -- yyyy-mm-dd or *
    lic_date = string.gsub(lic_date, "\n", "")
    local srvurl = luci.util.exec("uci get oplus.setting.srvurl 2>/dev/null")
    srvurl = string.gsub(srvurl, "\n", "")
    local target = luci.util.exec("grep -E \"^DISTRIB_TARGET=\" /etc/openwrt_release | cut -d'=' -f2 | sed \"s/'//g\"")
    target = string.gsub(target, "\n", "")
    local ver = luci.util.exec("uci get oplus.setting.ver 2>/dev/null")
    ver = string.gsub(ver, "\n", "")

    luci.http.prepare_content("application/javascript")
	luci.http.write("showData('".. devcode .. "','".. verify .."','".. lic_date .."','".. srvurl .. "', '".. target .. "', '".. ver .. "');")
end

function oplus_activate()
    local result = luci.util.exec("oplus-activate.sh")  -- ok, error, no_license
    result = string.gsub(result, "\n", "")
    luci.http.prepare_content("application/javascript")
	luci.http.write("onActivate('" .. result .. "');")
end

-- manually activate
function oplus_activate_m()
    local actcode = luci.http.formvalue("actcode")
    luci.util.exec("echo \"".. actcode .."\">/etc/oplus-license")
    local verify = luci.util.exec("oplus-util verify 2>/dev/null")  -- license_expired, license_ok, license_error
    verify = string.gsub(verify, "\n", "")
    luci.http.prepare_content("application/javascript")
	luci.http.write("onActivateM('" .. verify .. "');")
end